<?php
# Vicidial_international_DNC_interface.php - version 2.14
# 
# Copyright (C) 2022  Matt Florell <vicidial@gmail.com>, Joe Johnson <joej@vicidial.com>    LICENSE: AGPLv2
#
# ViciDial web-based DNC file loader from formatted file
# 
# CHANGES:
# 200813-1230 - First version 
# 220227-0848 - Added allow_web_debug system setting
#

require("dbconnect_mysqli.php");
require("functions.php");

if (file_exists('options.php'))
	{
	require('options.php');
	}

$US='_';
$MT[0]='';

$PHP_AUTH_USER=$_SERVER['PHP_AUTH_USER'];
$PHP_AUTH_PW=$_SERVER['PHP_AUTH_PW'];
$PHP_SELF=$_SERVER['PHP_SELF'];
$PHP_SELF = preg_replace('/\.php.*/i','.php',$PHP_SELF);
if (isset($_GET["DB"]))					{$DB=$_GET["DB"];}
	elseif (isset($_POST["DB"]))		{$DB=$_POST["DB"];}
if (isset($_GET["file_update_str"]))	{$file_update_str=$_GET["file_update_str"];}
	elseif (isset($_POST["file_update_str"]))	{$file_update_str=$_POST["file_update_str"];}

$DB=preg_replace("/[^0-9a-zA-Z]/","",$DB);

#############################################
##### START SYSTEM_SETTINGS LOOKUP #####
$stmt = "SELECT use_non_latin,admin_web_directory,custom_fields_enabled,webroot_writable,enable_languages,language_method,active_modules,admin_screen_colors,web_loader_phone_length,enable_international_dncs,allow_web_debug FROM system_settings;";
$rslt=mysql_to_mysqli($stmt, $link);
#if ($DB) {echo "$stmt\n";}
$qm_conf_ct = mysqli_num_rows($rslt);
if ($qm_conf_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$non_latin =					$row[0];
	$admin_web_directory =			$row[1];
	$custom_fields_enabled =		$row[2];
	$webroot_writable =				$row[3];
	$SSenable_languages =			$row[4];
	$SSlanguage_method =			$row[5];
	$SSactive_modules =				$row[6];
	$SSadmin_screen_colors =		$row[7];
	$SSweb_loader_phone_length =	$row[8];
	$SSenable_international_dncs =	$row[9];
	$SSallow_web_debug =			$row[10];
	}
if ($SSallow_web_debug < 1) {$DB=0;}
##### END SETTINGS LOOKUP #####
###########################################

$file_update_str = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$file_update_str);

if ($non_latin < 1)
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9a-zA-Z]/', '', $PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9a-zA-Z]/', '', $PHP_AUTH_PW);
	}
else
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_PW);
	}

$STARTtime = date("U");
$TODAY = date("Y-m-d");
$NOW_TIME = date("Y-m-d H:i:s");
$FILE_datetime = $STARTtime;
$date = date("r");
$ip = getenv("REMOTE_ADDR");
$browser = getenv("HTTP_USER_AGENT");

$NWB = "<i onClick=\"FillAndShowHelpDiv(event, '";
$NWE = "')\" class=\"fa fa-duotone fa-question\"></i>";

if ($non_latin > 0) {$rslt=mysql_to_mysqli("SET NAMES 'UTF8'", $link);}
$stmt="SELECT selected_language from vicidial_users where user='$PHP_AUTH_USER';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$sl_ct = mysqli_num_rows($rslt);
if ($sl_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$VUselected_language =		$row[0];
	}

$auth=0;
$auth_message = user_authorization($PHP_AUTH_USER,$PHP_AUTH_PW,'',1,0);
if ($auth_message == 'GOOD')
	{$auth=1;}

if ($auth < 1)
	{
	$VDdisplayMESSAGE = _QXZ("Login incorrect, please try again");
	if ($auth_message == 'LOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Too many login attempts, try again in 15 minutes");
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	if ($auth_message == 'IPBLOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Your IP Address is not allowed") . ": $ip";
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	Header("WWW-Authenticate: Basic realm=\"CONTACT-CENTER-ADMIN\"");
	Header("HTTP/1.0 401 Unauthorized");
	echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$PHP_AUTH_PW|$auth_message|\n";
	exit;
	}

$stmt="SELECT load_leads,user_group from vicidial_users where user='$PHP_AUTH_USER';";
$rslt=mysql_to_mysqli($stmt, $link);
$row=mysqli_fetch_row($rslt);
$LOGload_leads =	$row[0];
$LOGuser_group =	$row[1];

if (!$SSenable_international_dncs)
	{
	Header ("Content-type: text/html; charset=utf-8");
	echo "<div class=\"container-fluid alert alert-danger\">"._QXZ("Feature is currently disabled")."</div>";
	exit;
	}

if ($LOGload_leads < 1)
	{
	Header ("Content-type: text/html; charset=utf-8");
	echo "<div class=\"container-fluid alert alert-danger\">"._QXZ("You do not have permissions to load DNC leads")."</div>";
	exit;
	}

if (preg_match("/;|:|\/|\^|\[|\]|\"|\'|\*/",$LF_orig))
	{
	echo "<div class=\"container-fluid alert alert-danger\">"._QXZ("ERROR: Invalid File Name").":: $LF_orig</div>";
	exit;
	}

if ($file_update_str)
	{
	$upd_array=explode("|", $file_update_str);
	if ($upd_array[4]) {$status_clause="file_status='$upd_array[4]', ";}
	$upd_stmt="update vicidial_country_dnc_queue set $status_clause country_code='$upd_array[1]', file_action='$upd_array[2]', file_layout='$upd_array[3]' where dnc_file_id='$upd_array[0]'";
	$upd_rslt=mysql_to_mysqli($upd_stmt, $link);

	### LOG INSERTION Admin Log Table ###
	$log_stmt="INSERT INTO vicidial_admin_log set event_date=now(), user='$PHP_AUTH_USER', ip_address='$ip', event_section='LISTS', event_type='$upd_array[4]', record_id='$upd_array[0]', event_code='ADMIN LOAD DNC LIST', event_sql='', event_notes='DNC file ID: $upd_array[0]| File status: $upd_array[4]| File action: $upd_array[2]| File layout: $upd_array[3]";
	$log_rslt=mysql_to_mysqli($log_stmt, $link);
	}


$SSmenu_background='015B91';
$SSframe_background='D9E6FE';
$SSstd_row1_background='9BB9FB';
$SSstd_row2_background='B9CBFD';
$SSstd_row3_background='8EBCFD';
$SSstd_row4_background='B6D3FC';
$SSstd_row5_background='A3C3D6';
$SSalt_row1_background='BDFFBD';
$SSalt_row2_background='99FF99';
$SSalt_row3_background='CCFFCC';

if ($SSadmin_screen_colors != 'default')
	{
	$stmt = "SELECT menu_background,frame_background,std_row1_background,std_row2_background,std_row3_background,std_row4_background,std_row5_background,alt_row1_background,alt_row2_background,alt_row3_background FROM vicidial_screen_colors where colors_id='$SSadmin_screen_colors';";
	$rslt=mysql_to_mysqli($stmt, $link);
	if ($DB) {echo "$stmt\n";}
	$colors_ct = mysqli_num_rows($rslt);
	if ($colors_ct > 0)
		{
		$row=mysqli_fetch_row($rslt);
		$SSmenu_background =		$row[0];
		$SSframe_background =		$row[1];
		$SSstd_row1_background =	$row[2];
		$SSstd_row2_background =	$row[3];
		$SSstd_row3_background =	$row[4];
		$SSstd_row4_background =	$row[5];
		$SSstd_row5_background =	$row[6];
		$SSalt_row1_background =	$row[7];
		$SSalt_row2_background =	$row[8];
		$SSalt_row3_background =	$row[9];
		}
	}
$Mhead_color =	$SSstd_row5_background;
$Mmain_bgcolor = $SSmenu_background;
$Mhead_color =	$SSstd_row5_background;

#if ($DB) {print "SEED TIME  $secX      :   $year-$mon-$mday $hour:$min:$sec  LOCAL GMT OFFSET NOW: $LOCAL_GMT_OFF\n";}

header ("Content-type: text/html; charset=utf-8");

echo "<html>\n";
echo "<head>\n";
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"vicidial_stylesheet.php\">\n";
echo "<script language=\"JavaScript\" src=\"help.js\"></script>\n";
echo "<div id='HelpDisplayDiv' class='help_info' style='display:none;'></div>";
echo "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n";

echo "<script src=\"inc\libs\jquery\jquery.js\"></script>";
echo "<link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css\">";
echo "<link rel=\"stylesheet\" href=\"inc\libs\bootstrap\bootstrap.css\">";
echo "<link rel=\"stylesheet\" href=\"inc/js/multiselect/dist/css/bootstrap-multiselect.min.css\">";
echo "<link rel=\"stylesheet\" href=\"inc/js/multiselect/dist/css/bootstrap-multiselect.css\">";
echo "<link rel=\"stylesheet\" href=\"inc/libs/sidebar5/css/next-sidebar.css\" />";
echo "<link rel=\"stylesheet\" href=\"inc/libs/sidebar5/css/perfect-scrollbar.css\" />";
echo "<link rel=\"stylesheet\" href=\"inc/css/style.css\">";

echo "<!-- VERSION: $version     BUILD: $build -->\n";
echo "<!-- SEED TIME  $secX:   $year-$mon-$mday $hour:$min:$sec  LOCAL GMT OFFSET NOW: $LOCAL_GMT_OFF  DST: $isdst -->\n";

$layout_stmt="select container_entry from vicidial_settings_containers where container_id='DNC_IMPORT_FORMATS'";
$layout_rslt=mysql_to_mysqli($layout_stmt, $link);

$layouts=array();

while($layout_row=mysqli_fetch_row($layout_rslt)) 
	{
	$container_entry=$layout_row[0];
	$layout_rows=explode("\n", $container_entry);
	for ($i=0; $i<count($layout_rows); $i++) 
		{
		if (!preg_match('/^\#/', $layout_rows[$i]) && preg_match('/\=\>/', $layout_rows[$i]))
			{
			$current_layout=explode("=>", $layout_rows[$i]);
			if (strlen(trim($current_layout[0]))>0 && strlen(trim($current_layout[1]))>0) 
				{
				$layout_id=trim($current_layout[0]);
				$layouts["$layout_id"]=trim($current_layout[1]);
				}
			}
		}
	}
ksort($layouts);
?>

<script language="JavaScript">
function ModifyQueue(file_id, form_action)
	{
	if (!file_id) {return false;}
	var country_code_field="country_code_"+file_id;
	var file_action_field="file_action_"+file_id;
	var file_layout_field="file_layout_"+file_id;

	if (form_action=="PENDING" && (document.getElementById(country_code_field).value=="" || document.getElementById(file_action_field).value=="" || document.getElementById(file_layout_field).value=="")) {alert("File cannot be processed without assigning a country code, action, and layout"); return false;}

	var update_string=file_id+"|";
	update_string+=document.getElementById(country_code_field).value+"|";
	update_string+=document.getElementById(file_action_field).value+"|";
	update_string+=document.getElementById(file_layout_field).value+"|";
	if (form_action) {update_string+=form_action;}
	
	document.getElementById("file_update_str").value=update_string;
	document.forms["queue_form"].submit();
	}

function DisplayFormat(format_value, file_id)
	{
<?php
	$JSFormats="\tvar JSFormats={";
	foreach($layouts as $key => $value)
		{
		$JSFormats.="$key: \"$value\", ";
		}
	$JSFormats2=preg_replace('/, $/', '', $JSFormats);
	$JSFormats2.="};\n";
	echo $JSFormats2;

	reset($layouts);
?>

	var format_array=JSFormats[format_value].split(/,/);
	var format_text="";
	if (format_array[0]=="")
		{
		format_text+="<BR>No delimiter/fixed length, file is assumed pre-formatted";
		}
	else 
		{
		format_text+="<BR>File format: "+format_array[0];
		}

	if (format_array[1]!="") {format_text+="<BR>File delimiter: "+format_array[1];}
	
	format_text+="<BR>Phone location: ";
	for (j=2; j<format_array.length; j++)
		{
		if (format_array[j].match(/\|/)) 
			{
			var format_subarray=format_array[j].split(/\|/);
			format_text+="pos. "+format_subarray[0]+" length "+format_subarray[1]+",";
			}
		else
			{
			format_text+=format_array[j]+",";
			}
		}
	
	var format_text_field="file_layout_text_"+file_id;
	document.getElementById(format_text_field).innerHTML="<font face='arial, helvetica' size=1>"+format_text+"</font>";
	}

</script>
<title><?php echo _QXZ("ADMINISTRATION: Lead Loader"); ?></title>
</head>
<BODY BGCOLOR=WHITE marginheight=0 marginwidth=0 leftmargin=0 topmargin=0>

<?php
echo "<script language=\"JavaScript\" src=\"help.js\"></script>\n";
echo "<div id='HelpDisplayDiv' class='help_info' style='display:none;'></div>";

require("admin_header.php");

# print_r($layouts);

$stmt="select * from vicidial_country_dnc_queue order by date_uploaded asc";
$rslt=mysql_to_mysqli($stmt, $link);

echo "<div class=\"container-fluid admin_form_blocks\">";
echo "<div class=\"container-fluid text-center admin_form_heading admin_form_subHeading_with_helpIcon\"><div><span>"._QXZ("International DNC Loader")."</span></div><div class=\"admin_form_subHeading_helpIcon\">$NWB#international_dnc_loader$NWE</div></div>";
echo "<div class=\"container-fluid mt-3\">";

echo "<form action='$PHP_SELF' method='POST' name='queue_form'>";
echo "<table class=\"table table-sm table-bordered table-striped admin_form_table\">";
echo "<thead><tr>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("File name")."</th>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("Date loaded")."</th>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("Status")."</th>";
echo "<th style=\"vertical-align:middle;\"><div class=\"text-center admin_form_subHeading_with_helpIcon align-middle\" style=\"vertical-align:middle;\">"._QXZ("Country")." <div class=\"admin_form_subHeading_helpIcon\">$NWB#international_dnc_loader-country_code$NWE</div></div></th>";
echo "<th style=\"vertical-align:middle;\"><div class=\"text-center admin_form_subHeading_with_helpIcon align-middle\" style=\"vertical-align:middle;\">"._QXZ("Action (purge/append)")."<div class=\"admin_form_subHeading_helpIcon\">$NWB#international_dnc_loader-file_action$NWE</div></div></th>";
echo "<th style=\"vertical-align:middle;\"><div class=\"text-center admin_form_subHeading_with_helpIcon align-middle\" style=\"vertical-align:middle;\">"._QXZ("Layout")."<div class=\"admin_form_subHeading_helpIcon\">$NWB#international_dnc_loader-file_layout$NWE</div></div></th>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("Total records")."</th>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("Records processed")."</th>";
echo "<th style=\"vertical-align:middle;\">"._QXZ("Records inserted")."</th>";
echo "<th style=\"vertical-align:middle;\"><div class=\"text-center admin_form_subHeading_with_helpIcon align-middle\" style=\"vertical-align:middle;\">"._QXZ("Start/Cancel")."<div class=\"admin_form_subHeading_helpIcon\">$NWB#international_dnc_loader-start_cancel$NWE</div></div></th>";
echo "</tr></thead>";
if (mysqli_num_rows($rslt)==0)
	{
	echo "<tr><th colspan='10'><font face=\"arial, helvetica\" size=2>** "._QXZ("NO FILES LOADED")." **</font></th></tr>";
	}
while ($row=mysqli_fetch_array($rslt)) 
	{
	$id=$row["dnc_file_id"];
	$bgcolor="#CCCCCC";
	switch ($row["file_status"])
		{
			case "READY":
				$bgcolor="#CCFFFF";
				break;
			case "PENDING":
			case "PROCESSING":
				$bgcolor="#FFFFCC";
				break;
			case "CANCELLED":
			case "INVALID LAYOUT":
				$bgcolor="#FFCCCC";
				break;
			case "FINISHED":
				$bgcolor="#CCFFCC";
				break;
		}
	echo "<tr bgcolor='".$bgcolor."'>\n";
	echo "<td$row[filename]</td>";
	echo "<td$row[date_uploaded]</td>";
	echo "<td>$row[file_status]</td>";

	echo "<td><select class='form_field' name='country_code_".$id."' id='country_code_".$id."' class=\"custom-select\">";	
	if ($row["file_status"]!="FINISHED" && $row["file_status"]!="PROCESSING")  {echo "<option value=''></option>\n";}
	$country_stmt="select iso3, country_name from vicidial_country_iso_tld where iso3 is not null and iso3!='' order by country_name asc";
	$country_rslt=mysql_to_mysqli($country_stmt, $link);
	while($country_row=mysqli_fetch_row($country_rslt)) 
		{
		$iso=$country_row[0];
		$country_name=$country_row[1];
		if ($iso==$row["country_code"]) {$s=" selected";} else {$s="";}
		if (($row["file_status"]!="FINISHED" && $row["file_status"]!="PROCESSING") || $s)
			{
			echo "\t\t\t\t<option value='$iso'$s>$iso - $country_name</option>\n";
			}
		}	
	echo "</select></td>";

	echo "<td><select class='form_field' name='file_action_".$id."' id='file_action_".$id."' class=\"custom-select\">";
	echo "<option value='$row[file_action]'>"._QXZ("$row[file_action]")."</option>\n";
	if ($row["file_status"]!="FINISHED" && $row["file_status"]!="PROCESSING") 
		{
		echo "<option value='PURGE'>"._QXZ("PURGE")."</option>\n";
		echo "<option value='APPEND'>"._QXZ("APPEND")."</option>\n";
		}
	echo "</select></td>";
	echo "<td><select class='form_field' name='file_layout_".$id."' id='file_layout_".$id."' onChange='DisplayFormat(this.value, $id)' class=\"custom-select\">";
	echo "<option value='$row[file_layout]'>"._QXZ("$row[file_layout]")."</option>\n";
	if ($row["file_status"]!="FINISHED" && $row["file_status"]!="PROCESSING") 
		{
		foreach($layouts as $key => $value)
			{
			echo "<option value='$key'>$key</option>\n";
			}
		}
	echo "</select><span id='file_layout_text_".$id."'></span></font></td>";
	echo "<td>$row[total_records]</td>";
	echo "<td>$row[records_processed]</td>";
	echo "<td>$row[records_inserted]</td>";
	echo "<td nowrap>";
	if ($row["file_status"]!="FINISHED" && $row["file_status"]!="PROCESSING") {echo "<input type='button' class='green_btn' style='width:90px' value='START FILE' onClick=\"ModifyQueue($id, 'PENDING')\">&nbsp;&nbsp;&nbsp;<input type='button' class='red_btn' style='width:80px' value='CANCEL' onClick=\"ModifyQueue($id, 'CANCELLED')\">";} else {echo "&nbsp;";}
	# <BR><input type='button' class='blue_btn' style='width:60px' value='SAVE' onClick=\"ModifyQueue($id)\">
	echo "</td>";
	echo "</tr>";
	}
echo "<thead><tr><th colspan='10' style=\"text-align:center;\"><input type='button' onClick=\"window.location.href='$PHP_SELF'\" value='"._QXZ("REFRESH PAGE")."' class=\"btn btn-warning btn-sm\"></th></tr></thead>";
echo "</table>";
echo "<input type=hidden name='file_update_str' id='file_update_str'>";
echo "<input type=hidden name='DB' id='DB' value='$DB'>";
echo "</form>";
echo "</div>";
?>
</form>
</body>
<?php
echo "<script src=\"inc/libs/cookie/src/jquery.cookie.js\"></script>";
echo "<script src=\"inc/js/custom_javascript.js\"></script>";
echo "<script src=\"inc/libs/sidebar5/js/perfect-scrollbar.min.js\"></script>";
echo "<script src=\"inc/libs/lordicons/lordiIcon.js\"></script>";
echo "<script src=\"inc\libs\bootstrap\bootstrap.js\"></script>";
echo "<script src=\"inc/js/multiselect/dist/js/bootstrap-multiselect.js\"></script>";
echo "<script src=\"inc/libs/sidebar5/js/next-sidebar.js\"></script>";
echo "<script>	$(function(){  $('.multi_select').multiselect();});</script>";
?>
</html>
