<?php
# qc_call_client_iframe.php
#
# ViciDial database administration modify lead in vicidial_list
# 
# Copyright (C) 2012  poundteam.com    LICENSE: AGPLv2
# Copyright (C) 2022  Matt Florell <vicidial@gmail.com>    LICENSE: AGPLv2
#
# This script is designed to allow QC review and modification of leads, contributed by poundteam.com
#
# changes:
# 121116-1328 - First build, added to vicidial codebase
# 130621-2352 - Finalized changing of all ereg instances to preg
#             - Added filtering of input to prevent SQL injection attacks and new user auth
# 130902-0905 - Changed to mysqli PHP functions
# 140706-0826 - Incorporated includes into code
# 141007-2156 - Finalized adding QXZ translation to all admin files
# 141229-2013 - Added code for on-the-fly language translations display
# 170409-1533 - Added IP List validation code
# 210306-1052 - Changes for new QC module
# 210825-0937 - Removed custom fields, unused here.
# 210827-1818 - Fix for security issue
# 220224-0947 - Added allow_web_debug system setting
#

require("dbconnect_mysqli.php");
require("functions.php");

$PHP_AUTH_USER=$_SERVER['PHP_AUTH_USER'];
$PHP_AUTH_PW=$_SERVER['PHP_AUTH_PW'];
$PHP_SELF=$_SERVER['PHP_SELF'];
$PHP_SELF = preg_replace('/\.php.*/i','.php',$PHP_SELF);
if (isset($_GET["vendor_id"]))				{$vendor_id=$_GET["vendor_id"];}
	elseif (isset($_POST["vendor_id"]))		{$vendor_id=$_POST["vendor_id"];}
if (isset($_GET["phone"]))				{$phone=$_GET["phone"];}
	elseif (isset($_POST["phone"]))		{$phone=$_POST["phone"];}
if (isset($_GET["old_phone"]))				{$old_phone=$_GET["old_phone"];}
	elseif (isset($_POST["old_phone"]))		{$old_phone=$_POST["old_phone"];}
if (isset($_GET["lead_id"]))				{$lead_id=$_GET["lead_id"];}
	elseif (isset($_POST["lead_id"]))		{$lead_id=$_POST["lead_id"];}
if (isset($_GET["title"]))				{$title=$_GET["title"];}
	elseif (isset($_POST["title"]))		{$title=$_POST["title"];}
if (isset($_GET["first_name"]))				{$first_name=$_GET["first_name"];}
	elseif (isset($_POST["first_name"]))		{$first_name=$_POST["first_name"];}
if (isset($_GET["middle_initial"]))				{$middle_initial=$_GET["middle_initial"];}
	elseif (isset($_POST["middle_initial"]))	{$middle_initial=$_POST["middle_initial"];}
if (isset($_GET["last_name"]))				{$last_name=$_GET["last_name"];}
	elseif (isset($_POST["last_name"]))		{$last_name=$_POST["last_name"];}
if (isset($_GET["lead_name"]))				{$lead_name=$_GET["lead_name"];}
	elseif (isset($_POST["lead_name"]))		{$lead_name=$_POST["lead_name"];}
if (isset($_GET["phone_number"]))				{$phone_number=$_GET["phone_number"];}
	elseif (isset($_POST["phone_number"]))		{$phone_number=$_POST["phone_number"];}
if (isset($_GET["end_call"]))				{$end_call=$_GET["end_call"];}
	elseif (isset($_POST["end_call"]))		{$end_call=$_POST["end_call"];}
if (isset($_GET["DB"]))				{$DB=$_GET["DB"];}
	elseif (isset($_POST["DB"]))		{$DB=$_POST["DB"];}
if (isset($_GET["dispo"]))				{$dispo=$_GET["dispo"];}
	elseif (isset($_POST["dispo"]))		{$dispo=$_POST["dispo"];}
if (isset($_GET["list_id"]))				{$list_id=$_GET["list_id"];}
	elseif (isset($_POST["list_id"]))		{$list_id=$_POST["list_id"];}
if (isset($_GET["campaign_id"]))				{$campaign_id=$_GET["campaign_id"];}
	elseif (isset($_POST["campaign_id"]))		{$campaign_id=$_POST["campaign_id"];}
if (isset($_GET["phone_code"]))				{$phone_code=$_GET["phone_code"];}
	elseif (isset($_POST["phone_code"]))		{$phone_code=$_POST["phone_code"];}
if (isset($_GET["server_ip"]))				{$server_ip=$_GET["server_ip"];}
	elseif (isset($_POST["server_ip"]))		{$server_ip=$_POST["server_ip"];}
if (isset($_GET["extension"]))				{$extension=$_GET["extension"];}
	elseif (isset($_POST["extension"]))		{$extension=$_POST["extension"];}
if (isset($_GET["channel"]))				{$channel=$_GET["channel"];}
	elseif (isset($_POST["channel"]))		{$channel=$_POST["channel"];}
if (isset($_GET["call_began"]))				{$call_began=$_GET["call_began"];}
	elseif (isset($_POST["call_began"]))		{$call_began=$_POST["call_began"];}
if (isset($_GET["parked_time"]))				{$parked_time=$_GET["parked_time"];}
	elseif (isset($_POST["parked_time"]))		{$parked_time=$_POST["parked_time"];}
if (isset($_GET["tsr"]))				{$tsr=$_GET["tsr"];}
	elseif (isset($_POST["tsr"]))		{$tsr=$_POST["tsr"];}
if (isset($_GET["address1"]))				{$address1=$_GET["address1"];}
	elseif (isset($_POST["address1"]))		{$address1=$_POST["address1"];}
if (isset($_GET["address2"]))				{$address2=$_GET["address2"];}
	elseif (isset($_POST["address2"]))		{$address2=$_POST["address2"];}
if (isset($_GET["address3"]))				{$address3=$_GET["address3"];}
	elseif (isset($_POST["address3"]))		{$address3=$_POST["address3"];}
if (isset($_GET["city"]))				{$city=$_GET["city"];}
	elseif (isset($_POST["city"]))		{$city=$_POST["city"];}
if (isset($_GET["state"]))				{$state=$_GET["state"];}
	elseif (isset($_POST["state"]))		{$state=$_POST["state"];}
if (isset($_GET["postal_code"]))				{$postal_code=$_GET["postal_code"];}
	elseif (isset($_POST["postal_code"]))		{$postal_code=$_POST["postal_code"];}
if (isset($_GET["province"]))				{$province=$_GET["province"];}
	elseif (isset($_POST["province"]))		{$province=$_POST["province"];}
if (isset($_GET["country_code"]))				{$country_code=$_GET["country_code"];}
	elseif (isset($_POST["country_code"]))		{$country_code=$_POST["country_code"];}
if (isset($_GET["alt_phone"]))				{$alt_phone=$_GET["alt_phone"];}
	elseif (isset($_POST["alt_phone"]))		{$alt_phone=$_POST["alt_phone"];}
if (isset($_GET["email"]))				{$email=$_GET["email"];}
	elseif (isset($_POST["email"]))		{$email=$_POST["email"];}
if (isset($_GET["security"]))				{$security=$_GET["security"];}
	elseif (isset($_POST["security"]))		{$security=$_POST["security"];}
if (isset($_GET["comments"]))				{$comments=$_GET["comments"];}
	elseif (isset($_POST["comments"]))		{$comments=$_POST["comments"];}
if (isset($_GET["status"]))				{$status=$_GET["status"];}
	elseif (isset($_POST["status"]))		{$status=$_POST["status"];}
if (isset($_GET["rank"]))				{$rank=$_GET["rank"];}
	elseif (isset($_POST["rank"]))		{$rank=$_POST["rank"];}
if (isset($_GET["owner"]))				{$owner=$_GET["owner"];}
	elseif (isset($_POST["owner"]))		{$owner=$_POST["owner"];}
if (isset($_GET["submit"]))				{$submit=$_GET["submit"];}
	elseif (isset($_POST["submit"]))		{$submit=$_POST["submit"];}
if (isset($_GET["SUBMIT"]))				{$SUBMIT=$_GET["SUBMIT"];}
	elseif (isset($_POST["SUBMIT"]))		{$SUBMIT=$_POST["SUBMIT"];}
if (isset($_GET["CBchangeUSERtoANY"]))				{$CBchangeUSERtoANY=$_GET["CBchangeUSERtoANY"];}
	elseif (isset($_POST["CBchangeUSERtoANY"]))		{$CBchangeUSERtoANY=$_POST["CBchangeUSERtoANY"];}
if (isset($_GET["CBchangeUSERtoUSER"]))				{$CBchangeUSERtoUSER=$_GET["CBchangeUSERtoUSER"];}
	elseif (isset($_POST["CBchangeUSERtoUSER"]))		{$CBchangeUSERtoUSER=$_POST["CBchangeUSERtoUSER"];}
if (isset($_GET["CBchangeANYtoUSER"]))				{$CBchangeANYtoUSER=$_GET["CBchangeANYtoUSER"];}
	elseif (isset($_POST["CBchangeANYtoUSER"]))		{$CBchangeANYtoUSER=$_POST["CBchangeANYtoUSER"];}
if (isset($_GET["CBchangeDATE"]))				{$CBchangeDATE=$_GET["CBchangeDATE"];}
	elseif (isset($_POST["CBchangeDATE"]))		{$CBchangeDATE=$_POST["CBchangeDATE"];}
if (isset($_GET["callback_id"]))				{$callback_id=$_GET["callback_id"];}
	elseif (isset($_POST["callback_id"]))		{$callback_id=$_POST["callback_id"];}
if (isset($_GET["CBuser"]))				{$CBuser=$_GET["CBuser"];}
	elseif (isset($_POST["CBuser"]))		{$CBuser=$_POST["CBuser"];}
if (isset($_GET["modify_logs"]))			{$modify_logs=$_GET["modify_logs"];}
	elseif (isset($_POST["modify_logs"]))	{$modify_logs=$_POST["modify_logs"];}
if (isset($_GET["modify_closer_logs"]))			{$modify_closer_logs=$_GET["modify_closer_logs"];}
	elseif (isset($_POST["modify_closer_logs"]))	{$modify_closer_logs=$_POST["modify_closer_logs"];}
if (isset($_GET["modify_agent_logs"]))			{$modify_agent_logs=$_GET["modify_agent_logs"];}
	elseif (isset($_POST["modify_agent_logs"]))	{$modify_agent_logs=$_POST["modify_agent_logs"];}
if (isset($_GET["add_closer_record"]))			{$add_closer_record=$_GET["add_closer_record"];}
	elseif (isset($_POST["add_closer_record"]))	{$add_closer_record=$_POST["add_closer_record"];}
if (isset($_POST["appointment_date"]))			{$appointment_date=$_POST["appointment_date"];}
	elseif (isset($_GET["appointment_date"]))	{$appointment_date=$_GET["appointment_date"];}
if (isset($_POST["appointment_time"]))			{$appointment_time=$_POST["appointment_time"];}
	elseif (isset($_GET["appointment_time"]))	{$appointment_time=$_GET["appointment_time"];}

$DB=preg_replace("/[^0-9a-zA-Z]/","",$DB);

$STARTtime = date("U");
$TODAY = date("Y-m-d");
$NOW_TIME = date("Y-m-d H:i:s");
$date = date("r");
$ip = getenv("REMOTE_ADDR");
$browser = getenv("HTTP_USER_AGENT");

#############################################
##### START SYSTEM_SETTINGS LOOKUP #####
$stmt = "SELECT use_non_latin,custom_fields_enabled,enable_languages,language_method,qc_features_active,allow_web_debug FROM system_settings;";
$rslt=mysql_to_mysqli($stmt, $link);
#if ($DB) {echo "$stmt\n";}
$qm_conf_ct = mysqli_num_rows($rslt);
if ($qm_conf_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$non_latin =				$row[0];
	$custom_fields_enabled =	$row[1];
	$SSenable_languages =		$row[2];
	$SSlanguage_method =		$row[3];
	$SSqc_features_active =		$row[4];
	$SSallow_web_debug =		$row[5];
	}
if ($SSallow_web_debug < 1) {$DB=0;}
##### END SETTINGS LOOKUP #####
###########################################

$old_phone = preg_replace('/[^0-9]/','',$old_phone);
$phone_number = preg_replace('/[^0-9]/','',$phone_number);
	if (strlen($phone_number)<6) {$phone_number=$old_phone;}
$alt_phone = preg_replace("/\<|\>|\'|\"|\\\\|;/",'',$alt_phone);
$list_id = preg_replace('/[^0-9]/','',$list_id);
$lead_id = preg_replace('/[^0-9a-zA-Z]/','',$lead_id);
$entry_list_id = preg_replace('/[^0-9]/','',$entry_list_id);
$phone_code = preg_replace('/[^0-9]/','',$phone_code);
$update_phone_number=preg_replace('/[^A-Z]/','',$update_phone_number);
$vendor_lead_code = preg_replace('/;|#/','',$vendor_lead_code);
	$vendor_lead_code = preg_replace('/\+/',' ',$vendor_lead_code);
$source_id = preg_replace('/;|#/','',$source_id);
	$source_id = preg_replace('/\+/',' ',$source_id);
$gmt_offset_now = preg_replace('/[^-\_\.0-9]/','',$gmt_offset_now);
$country_code = preg_replace('/[^A-Z]/','',$country_code);
$gender = preg_replace('/[^A-Z]/','',$gender);
$date_of_birth = preg_replace('/[^-0-9]/','',$date_of_birth);
$comments = preg_replace('/;|#/','',$comments);
	$comments = preg_replace('/\+/',' ',$comments);
$rank = preg_replace('/[^0-9]/','',$rank);
$no_update = preg_replace('/[^A-Z]/','',$no_update);
$called_count=preg_replace('/[^0-9]/','',$called_count);
$local_gmt=preg_replace('/[^-\.0-9]/','',$local_gmt);
$callback = preg_replace('/[^A-Z]/','',$callback);
$callback_type = preg_replace('/[^A-Z]/','',$callback_type);
$end_call=preg_replace('/[^0-9]/','',$end_call);
$server_ip = preg_replace('/[^-\.\:\_0-9a-zA-Z]/','',$server_ip);
$extension = preg_replace("/\<|\>|\'|\"|\\\\|;/",'',$extension);
$channel = preg_replace("/\<|\>|\'|\"|\\\\|;/",'',$channel);
$submit = preg_replace('/[^- \.\_0-9a-zA-Z]/','',$submit);
$SUBMIT = preg_replace('/[^- \.\_0-9a-zA-Z]/','',$SUBMIT);
$modify_logs=preg_replace('/[^0-9]/','',$modify_logs);
$modify_closer_logs=preg_replace('/[^0-9]/','',$modify_closer_logs);
$modify_agent_logs=preg_replace('/[^0-9]/','',$modify_agent_logs);
$add_closer_record=preg_replace('/[^0-9]/','',$add_closer_record);
$call_began = preg_replace('/[^- \:\_0-9a-zA-Z]/','',$call_began);
$parked_time = preg_replace('/[^- \:\_0-9a-zA-Z]/','',$parked_time);
$callback_id = preg_replace('/[^-_0-9a-zA-Z]/','',$callback_id);
$CBchangeUSERtoANY = preg_replace('/[^-_0-9a-zA-Z]/','',$CBchangeUSERtoANY);
$CBchangeANYtoUSER = preg_replace('/[^-_0-9a-zA-Z]/','',$CBchangeANYtoUSER);
$CBchangeUSERtoUSER = preg_replace('/[^-_0-9a-zA-Z]/','',$CBchangeUSERtoUSER);
$CBchangeDATE = preg_replace('/[^-_0-9a-zA-Z]/','',$CBchangeDATE);
$archive_search = preg_replace('/[^-_0-9a-zA-Z]/','',$archive_search);
$archive_log = preg_replace('/[^-_0-9a-zA-Z]/','',$archive_log);
$gdpr_action = preg_replace('/[^-_0-9a-zA-Z]/','',$gdpr_action);
$CIDdisplay = preg_replace('/[^-_0-9a-zA-Z]/','',$CIDdisplay);
$appointment_date = preg_replace('/[^- \:\_0-9a-zA-Z]/','',$appointment_date);
$appointment_time = preg_replace('/[^- \:\_0-9a-zA-Z]/','',$appointment_time);
$vendor_id = preg_replace("/\<|\>|\"|\\\\|;/",'-',$vendor_id);
$phone = preg_replace("/\<|\>|\"|\\\\|;/",'-',$phone);
$title = preg_replace("/\<|\>|\"|\\\\|;/",'-',$title);
$first_name = preg_replace("/\<|\>|\"|\\\\|;/",'-',$first_name);
$middle_initial = preg_replace("/\<|\>|\"|\\\\|;/",'-',$middle_initial);
$last_name = preg_replace("/\<|\>|\"|\\\\|;/",'-',$last_name);
$lead_name = preg_replace("/\<|\>|\"|\\\\|;/",'-',$lead_name);
$tsr = preg_replace("/\<|\>|\"|\\\\|;/",'-',$tsr);
$address1 = preg_replace("/\<|\>|\"|\\\\|;/",'-',$address1);
$address2 = preg_replace("/\<|\>|\"|\\\\|;/",'-',$address2);
$address3 = preg_replace("/\<|\>|\"|\\\\|;/",'-',$address3);
$city = preg_replace("/\<|\>|\"|\\\\|;/",'-',$city);
$state = preg_replace("/\<|\>|\"|\\\\|;/",'-',$state);
$postal_code = preg_replace("/\<|\>|\"|\\\\|;/",'-',$postal_code);
$province = preg_replace("/\<|\>|\"|\\\\|;/",'-',$province);
$email = preg_replace("/\<|\>|\"|\\\\|;/",'-',$email);
$security = preg_replace("/\<|\>|\"|\\\\|;/",'-',$security);
$owner = preg_replace("/\<|\>|\"|\\\\|;/",'-',$owner);

if ($non_latin < 1)
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9a-zA-Z]/','',$PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9a-zA-Z]/','',$PHP_AUTH_PW);
	$campaign_id = preg_replace('/[^-_0-9a-zA-Z]/','',$campaign_id);
	$dispo = preg_replace('/[^-_0-9a-zA-Z]/','',$dispo);
	$status = preg_replace('/[^-_0-9a-zA-Z]/','',$status);
	$CBuser = preg_replace('/[^-_0-9a-zA-Z]/','',$CBuser);
	}	# end of non_latin
else
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_PW);
	$campaign_id = preg_replace('/[^-_0-9\p{L}]/u', '', $campaign_id);
	$dispo = preg_replace('/[^-_0-9\p{L}]/u', '', $dispo);
	$status = preg_replace('/[^-_0-9\p{L}]/u', '', $status);
	$CBuser = preg_replace('/[^-_0-9\p{L}]/u', '', $CBuser);
	}

$stmt="SELECT selected_language from vicidial_users where user='$PHP_AUTH_USER';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$sl_ct = mysqli_num_rows($rslt);
if ($sl_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$VUselected_language =		$row[0];
	}

$auth=0;
$auth_message = user_authorization($PHP_AUTH_USER,$PHP_AUTH_PW,'QC',1,0);
if ($auth_message == 'GOOD')
	{$auth=1;}

if ($auth < 1)
	{
	$VDdisplayMESSAGE = _QXZ("Login incorrect, please try again");
	if ($auth_message == 'LOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Too many login attempts, try again in 15 minutes");
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	if ($auth_message == 'IPBLOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Your IP Address is not allowed") . ": $ip";
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	Header("WWW-Authenticate: Basic realm=\"VICI-PROJECTS\"");
	Header("HTTP/1.0 401 Unauthorized");
	echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$PHP_AUTH_PW|$auth_message|\n";
	exit;
	}

$rights_stmt = "SELECT modify_leads,qc_enabled,qc_user_level from vicidial_users where user='$PHP_AUTH_USER';";
if ($DB) {echo "|$stmt|\n";}
$rights_rslt=mysql_to_mysqli($rights_stmt, $link);
$rights_row=mysqli_fetch_row($rights_rslt);
$modify_leads =		$rights_row[0];
$qc_enabled =		$rights_row[1];
$qc_user_level =	$rights_row[2];

if ( $qc_enabled < 1 )
	{
	header ("Content-type: text/html; charset=utf-8");
	echo _QXZ("QC is not enabled for your user account")."\n";
	exit;
	}
if ( $qc_user_level < 1 )
	{
	header ("Content-type: text/html; charset=utf-8");
	echo _QXZ("QC user level is too low")."\n";
	exit;
	}

//Is logged in admin user also logged in as an agent?
function is_user_logged_in($user)
	{
    global $link;
    $stmt="select status from vicidial_live_agents where user='$user'";
    if ($DB) {echo "|$stmt|\n";}
    $rslt=mysql_to_mysqli($stmt, $link);
    $live_agent_count = mysqli_num_rows($rslt);
    if($live_agent_count != '1')
		{
        if($live_agent_count == '0')
			{
            return _QXZ("Cannot call prospect. You are not logged in as")." $user.";
			} 
		else 
			{
            return _QXZ("Cannot call prospect").". $live_agent_count "._QXZ("agents logged in as")." $user.";
			}
		}
    $row=mysqli_fetch_row($rslt);
    $status = $row[0];
    if($status!='PAUSED')
		{
        return _QXZ("Status must be paused to call lead").". $user "._QXZ("is presently in")." $status "._QXZ("status").".";
		}
//@TODO: check user is in the correct CAMPAIGN for this lead.
    return true;
	}

$qc_user_logged_in=is_user_logged_in($PHP_AUTH_USER);
if ($qc_user_logged_in===true)
	{
    echo "<A HREF=qc_api.php?source=test&user=$PHP_AUTH_USER&pass=$PHP_AUTH_PW&agent_user=$PHP_AUTH_USER&function=external_dial_lead&value=$phone_number&phone_code=$phone_code&search=YES&preview=NO&focus=YES target='_SELF'>"._QXZ("Call Lead")."</A><BR><BR>";
	} 
else 
	{
    echo "$qc_user_logged_in<BR><BR>";
	}
echo "&nbsp;<A HREF=$PHP_SELF?phone_number=$phone_number&phone_code=$phone_code&lead_id=$lead_id&list_id=$CLlist_id&stage=DISPLAY&submit_button=YES&user=$PHP_AUTH_USER&pass=$PHP_AUTH_PW&bgcolor=E6E6E6>"._QXZ("Refresh")."</A>";

?>
